define(function () {

    var component = {
        methods: {},
        computed: {
            numberOfLinks: function () {
                var intNumberOfLinks = 0;
                if (this.view) {
                    for (var i in this.view.categories) {
                        for (var j in this.view.categories[i].links) {
                            intNumberOfLinks += 1;
                        }
                    }
                }
                return intNumberOfLinks;
            }
        }
    };

    component.originalTemplate = "visualTemplate";
    component.template = `
<wizdomWebpart data-v-0974784d :environmentInfo="environmentInfo" :chromeProperties="webpartProperties.chromeProperties" :dynamicData="numberOfLinks" chromeType="visual" :webpartPadding="true">
  <div data-v-0974784d class="module-root">
    <toolbar data-v-0974784d
      ref="toolbarComponent"
      :personalizationEnabled="personalizationEnabled"
      :environmentInfo="environmentInfo"
      :view="view"
      :webpartProperties="webpartProperties"
      @toolbarChanged="toolbarChangedEvent"
    >
    </toolbar> 

    <div data-v-0974784d v-bind:class="{ editMode: toolbarInEditMode }">
        <VisualDraggable data-v-0974784d
          :view="view"
          :inLinkEditMode="toolbarInEditMode"
          :webpartProperties="webpartProperties"
          :environmentInfo="environmentInfo"
          @OrderChanged="setLinkOrder"
          @editLinkClicked="editLinkClickedEvent"
          @deleteLinkClicked="deleteLinkClickedEvent"
          @deleteCorporateLinkClicked="deleteCorporateLinkClickedEvent"
          @editCategoryClicked="editCategoryClickedEvent"
          @deleteCategoryClicked="deleteCategoryClickedEvent" 
        />
    </div>
  </div>
</wizdomWebpart>
`;
    component.styles = `
/*
  Your use of the content in the files referenced here are subject to the terms of the license at http://aka.ms/fabric-font-license
*/
.ms-Pivot[data-v-0974784d] {
  font-family: "Segoe UI WestEuropean", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
  -webkit-font-smoothing: antialiased;
  box-sizing: border-box;
  margin: 0;
  padding: 0;
  -webkit-box-shadow: none;
  -moz-box-shadow: none;
  box-shadow: none;
  font-size: 14px;
  font-weight: 400;
}
.ms-Pivot-links[data-v-0974784d] {
  font-size: 0;
  height: 40px;
  list-style-type: none;
  padding: 0;
  white-space: nowrap;
}
.ms-Pivot-link[data-v-0974784d] {
  color: #333333;
  display: inline-block;
  font-size: 14px;
  font-weight: 400;
  line-height: 40px;
  margin-right: 8px;
  padding: 0 8px;
  text-align: center;
  vertical-align: top;
}
.ms-Pivot-link[data-v-0974784d]:hover {
    cursor: pointer;
}
.ms-Pivot-link[data-v-0974784d]::before {
    background-color: transparent;
    bottom: 0;
    content: '';
    height: 2px;
    left: 8px;
    position: absolute;
    right: 8px;
    transition: background-color 0.267s cubic-bezier(0.1, 0.25, 0.75, 0.9);
}
.ms-Pivot-link[data-v-0974784d]::after {
    color: transparent;
    content: attr(title);
    display: block;
    font-weight: bold;
    height: 1px;
    overflow: hidden;
    visibility: hidden;
}
.ms-Pivot-link.is-selected[data-v-0974784d] {
    font-weight: 600;
    position: relative;
}
.ms-Pivot-link.is-selected[data-v-0974784d]::before {
      background-color: #0078d7;
}
.ms-Pivot-link.is-disabled[data-v-0974784d] {
    color: #a6a6a6;
}
.ms-Pivot-link.ms-Pivot-link--overflow[data-v-0974784d] {
  color: #666666;
}
.ms-Pivot-link.ms-Pivot-link--overflow.is-selected[data-v-0974784d] {
    color: #0078d7;
}
.ms-Pivot-link.ms-Pivot-link--overflow[data-v-0974784d]:hover:not(.is-selected), .ms-Pivot-link.ms-Pivot-link--overflow[data-v-0974784d]:focus:not(.is-selected) {
    color: #212121;
}
.ms-Pivot-link.ms-Pivot-link--overflow[data-v-0974784d]:active {
    color: #0078d7;
}
.ms-Pivot-ellipsis[data-v-0974784d] {
  font-size: 15px;
  position: relative;
  top: 0;
}
.ms-Pivot-content[data-v-0974784d] {
  display: none;
  margin-top: 20px;
}
.ms-Pivot.ms-Pivot--large .ms-Pivot-link[data-v-0974784d] {
  font-size: 17px;
}
.ms-Pivot.ms-Pivot--large .ms-Pivot-link.is-selected[data-v-0974784d] {
    font-weight: 300;
}
.ms-Pivot.ms-Pivot--large .ms-Pivot-link.ms-Pivot-link--overflow[data-v-0974784d]::after {
  font-size: 17px;
}
.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link[data-v-0974784d] {
  height: 40px;
  background-color: #f4f4f4;
  line-height: 40px;
  margin-right: -2px;
  padding: 0 10px;
}
.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link[data-v-0974784d]:hover:not(.is-selected):not(.ms-Pivot-link--overflow), .ms-Pivot.ms-Pivot--tabs .ms-Pivot-link[data-v-0974784d]:focus:not(.is-selected):not(.ms-Pivot-link--overflow) {
    color: #000000;
}
.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link[data-v-0974784d]:active {
    color: #ffffff;
    background-color: #0078d7;
}
.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link.is-selected[data-v-0974784d] {
    background-color: #0078d7;
    color: #ffffff;
    font-weight: 300;
}
.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link.ms-Pivot-link--overflow[data-v-0974784d]:hover:not(.is-selected), .ms-Pivot.ms-Pivot--tabs .ms-Pivot-link.ms-Pivot-link--overflow[data-v-0974784d]:focus:not(.is-selected) {
  background-color: #ffffff;
}
.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link.ms-Pivot-link--overflow[data-v-0974784d]:active {
  background-color: #0078d7;
}
@media screen and (-ms-high-contrast: active) {
.ms-Pivot.ms-Pivot--tabs .ms-Pivot-link.is-selected[data-v-0974784d] {
    font-weight: 600;
}
}
.ms-Icon[data-v-0974784d] {
  color: "[theme:themePrimary, default: #333]";
}
.edit[data-v-0974784d] {
  color: "[theme:bodyText, default:#333]";
}
.ms-Pivot[data-v-0974784d] {
  margin-top: -2px;
  left: 20px;
}
.ms-Pivot-links[data-v-0974784d] {
  margin: 0 -8px 0 -4px;
  line-height: 30px;
}
iframe[data-v-0974784d] {
  height: 30px;
  width: 30px;
  overflow: hidden;
}
.edit[data-v-0974784d] {
  margin-bottom: 20px;
  display: inline-block;
}
.edit .ms-Icon[data-v-0974784d] {
    position: relative;
    top: 2px;
    margin-right: 6px;
}
.edit .edit-item[data-v-0974784d] {
    cursor: pointer;
    display: inline-block;
    margin-right: 15px;
}
.actions[data-v-0974784d] {
  display: inline-block;
  color: "[theme:bodyText, default:#333]";
}
.actions .ms-Icon[data-v-0974784d] {
    font-size: 13px;
    position: relative;
    top: 1px;
    margin-right: 5px;
}
.actions .action-item[data-v-0974784d] {
    /*margin: 10px 0 10px 0;*/
    cursor: pointer;
    display: inline-block;
    margin-right: 15px;
}


`;

    return component;

});
